drex_node_names = ["Connectivity Analysis Toolkit","License","Version history","Getting Started","Overview of Methods","Input files","Output files","Running the Toolkit from the GUI","Running the Toolkit from the Command Prompt","Flowchart of analysis process","Examples","Tutorial","Troubleshooting","Related Resources","System requirements","Contacts & Credits","Three Methods for Connectivity Analysis","Subset Centrality: Mapping Linkages","All-pairs Centrality: Mapping Landscape Connectivity","Network Flow Analysis of Time Series","Hexmap Tab","Graphs Tab","Connectivity Tab","Output Tab","Example 1: Shortest-path betweenness centrality (BC)","Example 2: Shortest-path betweenness subset centrality","Example 3: Comparison of subset and all-pairs current flow BC","Example 4: Comparison of shortest-path and current flow BC","Exercise 1 - Mapping linkages with min-cost-max-flow subset centrality","Exercise 2 - Mapping linkages with shortest-path subset centrality","Exercise 3 - Mapping landscape connectivity with all-pairs centrality ","Exercise 4 - Mapping connectivity under climate change: analysis of time series"];
drex_node_links = ["app.htm","ordering.htm","module_2.htm","getting-started.htm","module_4.htm","module_5.htm","module_6.htm","application-user-interface.htm","module_8.htm","module_9.htm","module_10.htm","module_11.htm","module_12.htm","related-resources.htm","system-requirements.htm","contacts.htm","module_4_1.htm","module_4_2.htm","module_4_3.htm","module_4_4.htm","module_7_1.htm","module_7_2.htm","module_7_3.htm","module_7_4.htm","module_10_1.htm","module_10_2.htm","module_10_3.htm","module_10_4.htm","module_11_1.htm","module_11_2.htm","module_11_3.htm","module_11_4.htm"];
drex_node_child_start = [1,16,16,16,16,20,20,20,24,24,24,28,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32];
drex_node_child_end = [16,16,16,16,20,20,20,24,24,24,28,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32];
drex_node_parent = new Array();
drex_node_deep = new Array();

function drex_node(ndx)
{
  this.node_index = ndx;
  this.title = drex_node_names[this.node_index];
  this.link = drex_node_links[this.node_index];
  this.deep = drex_node_deep[this.node_index];

  this.children = function(){
	var result = new Array(); 
	for (var i = drex_node_child_start[this.node_index]; i < drex_node_child_end[this.node_index]; i++) 
	  result.push(new drex_node(i));
	return result;
  };
  this.childrenCount = function(){
	if (drex_node_child_start[this.node_index] >= drex_node_child_end[this.node_index])
	  return 0;
	return drex_node_child_end[this.node_index] - drex_node_child_start[this.node_index];
  }
  this.parent = function(){
	if (drex_node_parent[this.node_index] == -1)
		return null;
	return new drex_node(drex_node_parent[this.node_index]);
  };
  this.isActive = function(){
	if (!drex.active_node)
		return false;
    return (this.node_index == drex.active_node.node_index)
  }
  this.isVisible = function(){
	if (this.node_index == 0)
		return 1;
	return true;
  }
};

drex_node_parent[0] = -1;
drex_node_deep[0] = 0;
for (var i in drex_node_names)
{
  for (var j = drex_node_child_start[i]; j < drex_node_child_end[i]; j++) 
  {
    drex_node_parent[j] = i;
    drex_node_deep[j] = drex_node_deep[i] + 1;
  }
}

drex = new Object();
drex.nodes_count = drex_node_names.length;

drex.root_node = function()
{
  return new drex_node(0);
}

drex.active_node = null;
for (var i in drex_node_links)
{
  if (drex_node_links[i] == drex_file_name)
    drex.active_node = new drex_node(i);
}


function drex_resultContainer(){
   this.result = "";
}

document.getElementsByClassName = function(tagName, clsNames)
{
	if (Object.prototype.toString.call(clsNames) != "[object Array]")
	{
		var temp = new Array();
		temp[clsNames] = true;
		clsNames = temp;
	}
	var arr = new Array();
	var elems = document.getElementsByTagName(tagName);
	for (var cls, i = 0; (elem = elems[i]); ++i)
	{
		var classNamesArray = elem.className.split(' ');
		for (var j = 0; j < classNamesArray.length; j++)
			if (clsNames[classNamesArray[j]])
				arr.push(elem);
	}
	return arr;
}

drex.onPreLoad = new Array();
drex.onGenerateContent = new Array();
drex.onLoad = new Array();

function onDocumentLoaded()
{
	for (var i = 0; i < drex.onPreLoad.length; i++)
		drex.onPreLoad[i]();
	for (var i = 0; i < drex.onGenerateContent.length; i++)
		drex.onGenerateContent[i]();
	for (var i = 0; i < drex.onLoad.length; i++)
		drex.onLoad[i]();
}

function escapeUrl(oldUrl)
{
	var result = oldUrl.replace(/%/g, "%25");
	result = result.replace(/'/g, "%27");
	result = result.replace(/;/g, "%3b");
	return result;
}

function escapeXml(str)
{
	var result = str.replace(/</g, "&lt;");
	result = result.replace(/>/g, "&gt;");
	result = result.replace(/&/g, "&amp;");
	return result;
}

function str2ar(str)
{
	var retVal = new Array();
	for (var i = 0; i < str.length; ++i)
		retVal.push(str.charCodeAt(i));
	return retVal;
}
function ar2str(arr)
{
	var str = "";
	for (var i = 0; i < arr.length; ++i)
		str += String.fromCharCode(arr[i]);
	return str;
}

drex.onSaveState = new Array();
drex.onLoadState = new Array();

function parseLocationParams() 
{
	var decodeString = function(str) 
	{
		var bits = base64.decode(str, 0, true, true);
		var result = ar2str(bits);
		result = utf8_decode(result);
		return result;		
	}
	map = new Array();

	if (!location.search.substring(1))
	{
		for (var i = 0; i < drex.onLoadState.length; i++)
			drex.onLoadState[i](map);
		return;
	}
	
	var stateParams = String(location.search.substring(1).split("?"));
	var paramArray = stateParams.split("&");

	for (index in paramArray) {
		var n = paramArray[index].indexOf("=");
		var key = paramArray[index].substring(0, n);
		var value = decodeString(paramArray[index].substring(n+1));
		map[key] = value;
	}
	
	for (var i = 0; i < drex.onLoadState.length; i++)
		drex.onLoadState[i](map);
}
function getLocationParams()
{
	var encodeString = function(str) 
	{
		var compressedStr = str;
		var utfEncodedStr = utf8_encode(compressedStr);
		var bitArray = str2ar(utfEncodedStr);
		return base64.encode(bitArray, false, true);	
	}

	map = new Array();
	for (var i = 0; i < drex.onSaveState.length; i++)
		drex.onSaveState[i](map);
		
	var result = "";
	for (var key in map)
	{
		value = encodeString(map[key]);
		if (result != "")
			result += "&";
		result += key + "=" + value;
	}
		
	return result;
}